#version 330
#extension GL_EXT_gpu_shader4 : enable
// Chanel Doodle #6mod01.fsh  by Flopine
//https://www.shadertoy.com/view/Mt3BDN
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// Code by Flopine

// Thanks to wsmind, leon, XT95, lsdlive, lamogui and Coyhot for teaching me
// Thanks LJ for giving me the love of shadercoding :3

// Cookie Collective rulz


#define ITER 64.
#define PI 3.141592
#define time iTime
#define BPM 25./2.
#define tempo BPM/60.

vec3 palette (float t, vec3 a, vec3 b, vec3 c, vec3 d)
{return a+b*cos(2.*PI*(c*t+d));}

float random (vec2 st)
{return fract(sin(dot(st.xy, vec2(12.2544, 35.1571)))*5418.548416);}

vec2 moda (vec2 p, float per)
{
    float a = atan(p.y, p.x);
    float l = length(p);
    a = mod(a-per/2., per)-per/2.;
    return vec2(cos(a),sin(a))*l;
}

vec2 mo(vec2 p, vec2 d)
{
    p = abs(p)-d;
    if (p.y > p.x) p.xy = p.yx;
    return p;
}

float stmin(float a, float b, float k, float n)
{
    float st = k/n;
    float u = b-k;
    return min(min(a,b), 0.5 * (u+a+abs(mod(u-a+st,2.*st)-st)));
}

float smin( float a, float b, float k )
{
    float h = max( k-abs(a-b), 0.0 );
    return min( a, b ) - h*h*0.25/k;
}

mat2 rot(float a)
{return mat2(cos(a),sin(a),-sin(a),cos(a));}

float sphe (vec3 p, float r)
{return length(p)-r;}

float od (vec3 p, float d)
{return dot(p, normalize(sign(p)))-d;}

float cyl (vec2 p, float r)
{return length(p)-r;}

float box( vec3 p, vec3 b )
{
    vec3 d = abs(p) - b;
    return min(max(d.x,max(d.y,d.z)),0.0) + length(max(d,0.0));
}

float sc (vec3 p, float d)
{
    p = abs(p);
    p = max(p.xyz, p.yzx);
    return min(p.x, min(p.y,p.z)) - d;
}

float prim1 (vec3 p)
{
    float s = sphe(p, 1.);
    p.xz = moda(p.xz, 2.*PI/4.);
    p.x -= 1.;
    return max(s, -od (p,.5));
}

float prim2(vec3 p)
{
    p.xy = mo(p.xy, vec2(2.));
    float p1 = prim1(p);
    p.xz *= rot(time*tempo);
    p.xz *= rot(p.y);
    p.xz = moda(p.xz, 2.*PI/8.);
    p.x -= 1.;
    return stmin(cyl(p.xz, 0.1), p1, 0.5, 4.);
}

float prim3(vec3 p)
{
    p.xy = moda(p.xy, 2.*PI/3.);
    p.x -= 4.;
    return prim2(p);
}

float prim4 (vec3 p)
{
    float per = 3.;
    p.xy *= rot(p.z*0.5);
    p.z = mod(p.z-per/2., per)-per/2.;
    return prim3(p);
}

float prim5(vec3 p)
{
    p.xz *= rot(time*tempo);
    p.xy *= rot(time * tempo);
    p *= 1.5;
    return stmin(sphe(p,1.), od(p,1.), 0.5, 4.);
}

float g = 0.;
float SDF(vec3 p)
{
    float d = min(prim4(p), prim5(p));
    g+=0.1/(0.1+d*d); 
    return d;
}

void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 uv = gl_FragCoord.xy/iResolution.xy;
    uv -= 0.5;
    uv /= vec2(iResolution.y / iResolution.x, 1);

    vec3 ro = vec3(0.001,0.001,-10.); vec3 p = ro;
    vec3 rd = normalize(vec3(uv,1.));

    float shad = 0.;
    float dither = random(uv);

    for (float i=0.; i<ITER; i++)
    {
        float d = SDF(p);
        if (d<0.001)
        {
            shad = i/ITER;
            break;
        }
        d *= 0.9 + dither*0.1;
        p += d*rd * 0.8;
    }

    float t = length(ro-p);

    vec3 pal = palette
        (abs(uv.y),
         vec3(0.5),
         vec3(0.5),
         vec3(0.5),
         vec3(0.5,0.3,0.2));

    vec3 c = vec3(shad) * pal;
    c = mix(c, vec3(0.,0.,0.2), 1.-exp(-0.01*t*t));
    c += g*0.05*(1.-length(uv));
    gl_FragColor = vec4(pow(c, vec3(0.45)),1.);
}
